// ****************************************************************************
//  ResetRes86                                                     01/Jan/2000
//
//  Written by Brian Layman (AKA Capt. Queeg AKA SilverPaladin)
//  Visit him at http://www.TheCodeCave.com
//
//  A rescue util for Windows machines that have been set to a resolution not
//  supported by the monitor.  This has made me a hero for many a customer.
//
//  I also used two modified versions of this tool, each associated with a
//  hot key to switch between the resolution my monitors at could use and
//  the resolution my monitors at home could use back when I strapped a
//  handle onto my work computer and carried it back and forth.
//
//  Warning: This routine changes your Windows settings.  It can be used as a
//    joke or a tool. It is a good best practice to understand every line
//    of new code before you run it, who knows what could be lurking. Better
//    yet, do not run this example at all. You should stop right now and erase
//    the files.  For if it causes blue smoke to be emitted from your network
//    card, if it erases all users from your computer, or if it makes your
//    sister break up with her lawyer boyfriend and start dating a caver, it
//    is not my fault.  (Actually that last one might be an improvement, but
//    it is still not my fault.) But the fact of the matter is, computers
//    have a mind of their own and we programmers live on the wild side.
//
//  Usage: ResetRes.exe
//    Simply place this file in the folder:
//    C:\Documents and Settings\All Users\Start Menu\Programs\Startup
//    and reboot the computer.  When the next person logs it, the monitor
//    will be at a resolution and hz cycle supported by all modern CRT and
//    LCDs.
//
//  Suggested Usage: If you have a game that 
//
//  Donations - If this program & source really helps you out, feel free to
//    buy me a cappacino, movie ticket, ebook, or something else small for
//    my next "Dad's Night Out". You can Paypal to Brian@TheCodeCave.com. Or
//    leave a comment on my blog with your country of origin. Or even better
//    yet, add me to your blog roll.
//
//  History:
//         01/Jan/2000 - BL - Created
//
// ****************************************************************************
program ResetRes86;

uses
  Forms, Windows;

{$R *.RES}

var
  pDMode : _DEVICEMODEA;
begin
  // The only required line for a Delphi app...
  Application.Initialize;

  // Assign the desired device mode
  // The BitsPerPel is the only non-selfexlanatory setting I think.
  // It controls the color depth as follows.
  // 4 = "16 Colors"
  // 8 = "256 Colors"
  // 16 = "High Color"
  // 24, 32 = "True Color"
  pDMode.dmBitsPerPel := 8;
  pDMode.dmPelsWidth  := 800;
  pDMode.dmPelsHeight := 600;

  // Some touch screen LCDs don't display at a rate higher than 60
  pDMode.dmDisplayFrequency := 60;

  // Mark the items that we are changing.
  PDMode.DmFields := (DM_BITSPERPEL or DM_PELSWIDTH or DM_PELSHEIGHT or DM_DISPLAYFREQUENCY);
  // Pass in the size, since we could change any number of fields.
  pDMode.dmSize := SizeOf(pDMode);

  // Call ChangeDisplaySettings to assign the settings to the registry and make
  // it take effect.
  // CDS_UPDATEREGISTRY  The graphics mode for the current screen will be changed
  // dynamically and the graphics mode will be updated in the registry. The mode
  // information is stored in the USER profile.
  ChangeDisplaySettings(pDMode, CDS_UPDATEREGISTRY);
end.
